/*
 * beam.c
 * - code to beam texts across the TCP connection following a
 * special protocol (used only on MUME so far)
 * 
 */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <errno.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/types.h>
#ifndef WIN32
#include <sys/time.h>
#include <sys/wait.h>
#else
#include <process.h>
#include <io.h>
#endif
#include <signal.h>
#include <sys/stat.h>

#include "cancan.h"
#include "term.h"
#include "xeval.h"

void bcopy();

#ifdef NOBCOPY
#define bcopy(a,b,c) my_memmove ((b), (a), (c))
#endif

extern time_t time(); /* ??? necessary ??? */

static char **split_line();
static void finish_edit();

editsess *edit_sess;	/* head of session list */

char edit_start[BUFSIZE]; /* messages to send to host when starting */ 
char edit_end[BUFSIZE];   /* or leaving editing sessions */ 

void WaitEditorThread(void *);

/*
 * Process editing protocol message from buf with len remaining chars.
 * Return number of characters used in the message.
 */
int process_message(buf, len)
char *buf; int len;
{
    int msglen, i, l, used;
    char *text;
    
    msglen = atoi(buf + 1);
    for(i = 1; i < len && isdigit(buf[i]); i++)
      ;
    if(buf[i] == '\r')
      i++;
    if(buf[i++] != '\0' || i >= len) 
    {
	PRINT_INT ("#Warning: protocol error\n");
	return len;
    }
    text = (char*)malloc(msglen);
    if (!text)
      syserr("malloc");
    l = len - i;
    if(msglen < l) 
    {
	l = msglen;
	used = msglen + i;
    }
    else
      used = len;
    bcopy(buf + i, text, l);
    i = l;
    while(i < msglen) 
    {
	/*
	 * read() might block here, but it should't be long. I should also
	 * process any telnet protocol commands, but I don't care right now.
	 */
	while((l = recv(sockfd, text + i, msglen - i, 0)) < 0 && errno == WSAEINTR)
	  ;
	tty_printf("\rgot %d bytes out of %d", i, msglen);
	tty_flush();
	if(l < 0)
	  syserr("read message from socket");
	i += l;
    }
    tty_printf("\rread all %d bytes.%s\n", msglen, clreoln);
    switch(*buf) 
    {
     case 'E':
	message_edit(text, msglen, 0, 0);
	break;
     case 'V':
	message_edit(text, msglen, 1, 0);
	break;
     default:
	tty_printf("#Warning: received a funny message (0x%x)\n", *buf);
	free(text);
	break;
    }
    return used;
}

/*
 * start an editing session: process the EDIT/VIEW message
 * if view == 1, text will be viewed, else edited
 */
extern void message_edit(text, msglen, view, builtin)
char *text;
int msglen;
char view, builtin;
{
  char tmpname[LINELEN], buf[LINELEN], olle[256];
  int key;
  int i;
  editsess *s;
  char *editor, *descr;
  //char **args;
  int waitforeditor;
  FILE *tmpfile;

  char *my_env[] = {
	  "PATH=c:\\windows;c:\\windows\\command",
	  NULL
  };

  if(view) {
    key = -1;
    i = 0;
  } else {
	if(text[0] != 'M') {
		tty_printf("#Warning: protocol error (message_edit, no M)\n");
		free(text);
		return;
	}
    for(i = 1; i < msglen && isdigit(text[i]); i++);
    if(text[i++] != '\n' || i >= msglen) {
		tty_printf("#Warning: protocol error (message_edit, no \\n)\n");
		free(text);
		return;
    }
    key = atoi(text + 1);
  }
  descr = text + i;
  while(i < msglen && text[i] != '\n')
	  i++;
  if(i >= msglen) {
     tty_printf("#Warning: protocol error (message_edit, no desc)\n");
     free(text);
     return;
  }
  text[i++] = '\0';
 
  sprintf(olle, "cc%d.txt", key); 

  if((tmpfile = fopen(olle, "wb")) < 0)
     syserr("create temporary edit file");
  if(fwrite(text + i, 1, msglen - i, tmpfile) < msglen - i)
     syserr("write to temp edit file");
  fclose(tmpfile);

  /*	if((tmpfd = open(olle, _O_WRONLY | _O_CREAT | _O_BINARY, 0777)) < 0)
     syserr("create temporary edit file");
  if(write(tmpfd, text + i, msglen - i) < msglen - i)
     syserr("write to temp edit file");
  close(tmpfd);
*/
  //tty_printf("written %d bytes\n", msglen - i);

  /* send a edit_start message (if wanted) */ 
  if ((!edit_sess) && (*edit_start)) {
     error = 0;
     parse_instruction(edit_start, 0, 0);
     history_done = 0;
  }

  s = (editsess*)malloc(sizeof(editsess));
  if (!s)
    syserr("malloc");
  s->ctime = time((time_t*)NULL);
  s->oldsize = msglen - i;
  s->key = key;
  s->builtin = builtin;
  s->descr = strdup(descr);
  s->file = strdup(olle);
  
  free(text);
  if(view) {
     if(!(editor = getenv("CANCANPAGER")) && !(editor = getenv("PAGER")))
		 editor = "c:\\windows\\command\\more.com";
  } else {
     if(!(editor = getenv("CANCANEDITOR")) && !(editor = getenv("EDITOR")))
		 editor = "&pfe32.exe";
  }
  if(editor[0] == '&') {  // asynchronous editing?
     waitforeditor = 0;
     editor++;
  } else {
     waitforeditor = 1;
  }
      
  if(waitforeditor) {
	// do a synchronous spawn - it will wait for the editor to finish
	if(_spawnl(_P_WAIT, editor, editor, olle, NULL)<0)
		syserr("cannot spawn editor");
  } else {
	// do an asynchronous spawn, save the process handle in s->pid
	// the /m command in association with PFE forces it to open a new app
	if(!strcmp("&pfe32.exe", editor))
		s->pid = _spawnl(_P_NOWAIT, editor, editor, "/m", olle, NULL);
	else
		s->pid = _spawnl(_P_NOWAIT, editor, editor, olle, NULL);
	if(s->pid < 0)
		syserr("cannot spawn editor");
	_beginthread(WaitEditorThread, 4096, (LPVOID)s->pid);
  }

  if(waitforeditor) {
     finish_edit(s);
     free(s->descr);
     free(s->file);
     set_terminal();
     if (!edit_sess && *edit_end) {
        error = 0;
        parse_instruction(edit_end, 0, 0);
		history_done = 0;
     }

     if (!s->builtin) {
         tty_gotoxy(0, lines - 1);
	 tty_printf("\n%s", promptstr);
         redraw_input();
	 tty_flush();
         line0 = lines - 1;
     }
     free(s);
  } else {
     s->next = edit_sess;
     edit_sess = s;
  }
}

/*
 * split a command line into arguments:
 * return static NULL-terminated array of arguments
 * the line is assumed to be trashable.
 */
static char **split_line(line)
char *line;
{
  char *p;
  static char *args[MAXARGS + 1];
  int i;
  
  p = strtok(line, " ");
  for(i = 0; p != NULL && i < MAXARGS; p = strtok(NULL, " "),	i++)
     args[i] = p;
  args[i] = NULL;
  return args;
}

// wait for the editor process with id given in pd
// when finished, send back file to the mud if changed

void WaitEditorThread(LPVOID pd)
{
  int pid, ret;
  editsess **sp, *p;
 
  pid = (int)pd;

  // wait for the editor process to finish
  if(_cwait(&ret, pid, NULL) < 0) {
	tty_printf("There is something rotten in the state of Denmark.\n");
	return;
  }

  // find editor session in the list using the pid
  for(sp = &edit_sess; *sp && (*sp)->pid != pid; sp = &(*sp)->next);
  if(*sp) {
	if((*sp)->key >= 0)	/* send back reply message? */
	   finish_edit(*sp);
	p = *sp; *sp = p->next;
	free(p->descr);
	free(p->file);
	free((char*)p);
  }

  /* send the edit_end message if this is the last editor... */ 
  if ((!edit_sess) && (*edit_end))
   {
     int osockfd = sockfd;  /* backup current socket fd */
     sockfd = main_sess();
     error = 0;
     parse_instruction(edit_end, 0, 0);  /* KLUDGE!!!  (oh well...) */
     history_done = 0;
     sockfd = osockfd;
   }
}

/*
 * send back edited text to server, or cancel the editing session if the
 * file was not changed.
 */
static void finish_edit(sp)
editsess *sp;
{
 int fd;
 char *msg, *text;
 int txtlen, hdrlen;
 struct stat sbuf;
 char keystr[16];
  
  if (sp->builtin) {
    if(unlink(sp->file) < 0) syserr("unlink edit file");
    return;
  }
  fd = open(sp->file, _O_RDONLY | _O_BINARY);
  if(fd < 0) syserr("open edit file");
  if(fstat(fd, &sbuf) < 0) syserr("fstat");
  txtlen = sbuf.st_size;
  tty_printf("st_size = %d\n", txtlen);
  if(sbuf.st_mtime > sp->ctime)// || txtlen != sp->oldsize) 
   {
	  int ll, crs, loop;
	  /* file was changed by editor: send back result to server */
     
     text = (char*)malloc(txtlen + 1);	/* +1 is for possible LF */
     if (!text)
       syserr("malloc");
     if((ll = read(fd, text, txtlen)) < txtlen) {
     	syserr("read edit file");
	 }     
	 tty_printf("read returned %d bytes:\n", ll);
	 
	 for(crs = 0, loop = 0; loop < txtlen; loop++)
		 if(text[loop] == 13)
			crs++;

     if(txtlen && text[txtlen - 1] != '\n') 
      {
	/* If the last line isn't LF-terminated, add an LF */
	text[txtlen] = '\n';
	txtlen++;
      }
     
     sprintf(keystr, "E%d\n", sp->key);
     msg = (char*)malloc(txtlen + 64);	/* 64 is safety margin */
     if (!msg)
       syserr("malloc");
	 // for some reason CR's get eaten on their way to mume - so subtract them
	 // from the length mume expects!!
     sprintf(msg, "%sE%d\n%s", MPI, (int)(txtlen + strlen(keystr) - crs), keystr);
     hdrlen = strlen(msg);
     bcopy(text, msg + hdrlen, txtlen);
     free(text);

     msg[hdrlen + txtlen] = '\0';
     send_to_main_host(msg);
     PRINT_INT ("#completed session %s (%d)\n", sp->descr, sp->pid);
     
   } 
  else
   {
     /* file wasn't changed, cancel editing session */
     sprintf(keystr, "C%d\n", sp->key);
     msg = (char*)malloc(64);
     if (!msg)
       syserr("malloc");
     sprintf(msg, "%sE%d\n%s", MPI, (int) strlen(keystr), keystr);

     send_to_main_host(msg);
     PRINT_INT("#cancelled session %s (%d)\n", sp->descr, sp->pid);
   }
  
  free(msg);
  close(fd);
  if(unlink(sp->file) < 0) syserr("unlink edit file");
}
