/*
 * cancan.h
 * various constants etc
 */

#ifdef PROGRESS_CHECKING
#define CHECK(n) printf("#Check point %d passed.\n", n), fflush(stdout)
#else
#define CHECK(n)
#endif

#ifndef LONG_MIN
#define LONG_MIN ((long)((unsigned long)1L << sizeof(long) * 8 - 1))
#endif

#ifndef LONG_MAX
#define LONG_MAX ((long)(((unsigned long)1L << sizeof(long) * 8 - 1) - 1))
#endif

#define uSEC_PER_SEC 1000000L  /* microseconds in a second */
#define mSEC_PER_SEC 1000L     /* milliseconds in a second */
#define uSEC_PER_mSEC 1000L    /* microseconds in a millisecond */

#ifndef _H_SYS_TIME
#ifndef WIN32
#include <sys/time.h>
#endif
#endif
#ifdef WIN32
#include <winsock.h>
#include <time.h>
#endif


typedef struct timeval vtime;   /* needs #include <sys/tyme.h> */

typedef struct 
{               		/* for additional connected sessions */
  int active;			/* display remote output? */
  char *id;			/* session id */
  char *host;                   /* address of remote host */
  int port;                     /* port number of remote host */
} consess;

/* generic linked list node (never actually created) */
typedef struct defnode {
    struct defnode *next;
    char *sortfield;
} defnode;

/* linked list nodes: keep the next pointer first, then string to sort by */
typedef struct aliasnode {
    struct aliasnode *next;
    char *name;
    char *subst;
} aliasnode;

typedef struct actionnode {
    struct actionnode *next;
    char *pattern;
    char *command, *label;
    int active;
} actionnode;

typedef struct marknode {
    struct marknode *next;
    char *pattern;
    int attrcode;
} marknode;

typedef struct keynode {
    struct keynode *next;	/* next key definition in list */
    char *name;			/* key name */
    char *sequence;		/* escape sequence sent by terminal */
    void (*funct)();		/* function called when key pressed */
    char *call_data;		/* data passed to function */
} keynode;

typedef struct delaynode {
    struct delaynode *next;
    char *name;
    char *command;
    vtime when;                 /* structure containing time when */
				/* command must be executed */
} delaynode;

typedef struct varnode {        /* for named variables */
    struct varnode *next;
    char *name;
    int index;
    long num;
    char *str;
} varnode;

/* shared functions: */

/* from cancan.c */
void read_settings();
void setsigs();
void connect_sess();
void disconnect_sess();
void show_connections();
void show_host();
void exitcancan();
void syserr();
char *skipspace();
void process_remote_input();
void put_marks();
void wrap_print();
void smart_print();
void suspend_cancan();
int is_main_sess();
int main_sess();
int find_sess();
void send_to_main_host();
void setfile();
void save_settings();
void strdel();
void strins();
void showprompt();
void parse_user_input();
char *parse_instruction();
void to_input_line();
void cancel_edit();
void set_param();
void restore_param();
void subst_param();
void printver();
void snoop_sess();
void flashparen();
void put_in_history();
void put_word();
char *split_first_word();
int printstrlen();
int parse_walk();

/* from xeval.c */
void my_memmove();

/* from mapping.c */
void retrace_steps();
void show_automap();
void print_automap();
void add_dir_to_map();

/* from tel.c */
int doconnect();
int read_socket();
void send_to_host();
void flush_output_buffer();
void send_term_size();

/* from list.c */
long diff_vtime();
void add_vtime();
int cmp_vtime();
int time_sort();
int rev_time_sort();
void add_node();
void add_aliasnode();
void add_actionnode();
void add_marknode();
void add_keynode();
void add_delaynode();
varnode *add_varnode();
aliasnode **lookup_alias();
actionnode **lookup_action();
actionnode **lookup_action_pattern();
marknode **lookup_marker();
keynode **lookup_key();
delaynode **lookup_delay();
varnode **lookup_varnode();
void delete_aliasnode();
void delete_actionnode();
void delete_marknode();
void delete_keynode();
void delete_delaynode();
void delete_varnode();

/* from beam.c */
void message_edit();
int process_message();
void childdeathsig();

#define PRINT_INT if(!internal) internal=1; tty_printf

#define MAXFDSCAN 128		/* max number of fd to scan in select() */
#define MAXHIST 128		/* number of history lines kept */
#define NIL_CHAR '`'            /* special escape char (there is also \ ) */
#define DELIM " ;"		/* word delimiting characters */
#define SPECIAL_CHARS "{}();\"=" /* specials chars needing escape */
#define CAPLEN 20		/* max length of a terminal capability */
#define BUFSIZE 4096		/* general buffer size */
#define OUTBUFSIZE 4096         /* output buffer size */
#define LINELEN 1024		/* maximum line length */
#define PARAMLEN 1024		/* maximum length of string params (&x, $x) */
#define NUMPARAM 10             /* number of different params allowed */
#define NUMVAR 50               /* number of global variables allowed */
#define MAXMAPLEN 500		/* maximum length of automapped path */
#define WORDSKEPT 512		/* number of words kept for TAB-completion */
#define MPI "~$#E"		/* MUME protocol introducer */
#define SOCKBUFSIZE 4096	/* socket buffer size for read */
#define MAXSUBOPT 256		/* max length of suboption string */
#define MAXARGS 16		/* max number of arguments to editor */
#define FLASHDELAY 500	        /* time of parentheses flash in millisecs */
#define CMDSEP ';'		/* command separator character */
#define KBD_TIMEOUT 35000	/* timeout for keyboard read in microsecs;
				   35000 should be enough for 300+ baud */

/* Variable struct definitions */
typedef struct {                       /* holds value of local parameters */
  long num[NUMPARAM];
  char str[NUMPARAM][PARAMLEN];
} params;

typedef struct {                       /* vector element of pointers */
  long *num;                           /* to ALL variables */
  char *str;
} vars;

#define MAX_STACK 100

typedef struct {
  params *p[MAX_STACK];
  int curr;
} param_stack;

#define LM_NOECHO 1	/* no local echo */
#define LM_CHAR 2	/* char-by-char mode (no line editing) */

/* editing session control */
typedef struct editsess_ 
{
  int key;		/* session identifier (-1 if cancelled) */
  char builtin;         /* 1 if viewing built-in text */
  int pid;		/* pid of child */
  char *descr;  	/* short description of what we are editing */
  char *file;		/* name of temporary file */
  time_t ctime; 	/* time when temp file was created (upper bound) */
  long oldsize; 	/* original file size */
  struct editsess_ *next;
} editsess;

/* shared vars */
/* from cancan.c */
extern int internal;
extern char history_done;
extern int linemode;		/* line mode with flags as above (LM_*) */
extern volatile int sockfd;		/* socket file descriptor */
extern char hostname[], portnumber[];
extern char deffile[], helpfile[];

extern HANDLE outcons; 

extern int cols, lines;		/* terminal window size */
extern int line0, col0;		/* origin of input line */
extern char promptstr[];	/* prompt string */
extern int promptlen;           /* length of prompt string */
extern char promptintercept;    /* 1 if prompt was intercepted by an #action */
extern char edbuf[];		/* input line buffer */
extern int edlen;		/* characters in edbuf */
extern int pos;			/* cursor position in edbuf */
extern char edattrbeg[], edattrend[];

extern long received, sent;
extern clock_t start_clock, cpu_clock;

extern aliasnode *aliases;
extern actionnode *actions;
extern marknode *markers;
extern int a_nice;
extern keynode *keydefs;
extern delaynode *delays;
extern delaynode *dead_delays;
extern varnode *named_vars[2];
extern int num_named_vars[2];
extern int max_named_vars;
extern vars *var;
extern vtime now, start_time, ref_time;

extern char initstr[];
extern FILE *capfile, *recordfile;
extern char prefixstr[];
extern char inserted_next[];
extern char verbatim;

extern char speedwalk;
extern char compactmode;
extern char wrap;
extern char echo_int;
extern char echo_ext;
extern char debug;

extern char *hist[];
extern int curline;
extern int pickline;

/* from beam.c */
extern char edit_start[];
extern char edit_end[];
extern editsess *edit_sess;

#define CONTROL(c) ((c) & 0x1f)

/* macros to find cursor position from input buffer position */
#define CURLINE(pos) (((pos) + col0) / (cols - 1) + line0)
#define CURCOL(pos) (((pos) + col0) % (cols - 1))

/* macros to match parentheses */
#define ISRPAREN(c) ((c) == ')' || (c) == ']' || (c) == '}')
#define ISLPAREN(c) ((c) == '(' || (c) == '[' || (c) == '{')
#define LPAREN(c) ((c) == ')' ? '(' : ((c) == ']' ? '[' : '{'))

#define MIN(a, b) ((a) < (b) ? (a) : (b))
#define MAX(a, b) ((a) > (b) ? (a) : (b))

/*
 * Attribute codes: bit 0-7 for foreground colour or effects, 8-15 for
 * background colour. Colour #16 is "none", so 0x1010 is "no attribute".
 */
#define COLOURS 16		/* number of colours on HFT terminal */
#define LOWCOLOURS 8            /* number of ANSI colours */
#define NOATTRIB COLOURS	/* no colour change, use default */
#define BOLD (COLOURS + 1)
#define UNDERLINE (COLOURS + 2)
#define INVERSE (COLOURS + 3)
#define TOK_ON (COLOURS + 4)	/* these two used by attr_token() */
#define TOK_INVALID (-1)

/* constructors / accessors for attribute codes */
#define ATTRCODE(fg, bg) ((fg) | ((bg << 8)))
#define FOREGROUND(attrcode) ((attrcode) & 0xFF)
#define BACKGROUND(attrcode) ((attrcode) >> 8)

#define NOATTRCODE ATTRCODE(NOATTRIB, NOATTRIB)

/*
 * NCSA telnet 2.2 doesn't reset the colour when it receives "esc [ m",
 * so we must know what the normal colours are in order to reset it.
 * These colours can be changed with the #color command.
 */
#ifdef TELNETBUG
#define DEFAULTFG 7		/* make default white text */
#define DEFAULTBG 4		/* on blue background */
#endif
