/*
 * mapping routines cleaned up. I hope they still work as intended by the
 * original author.
 */

#include <stdio.h>
#include <stdlib.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <string.h>
#include <sys/types.h>
#ifndef WIN32
#include <sys/time.h>
#endif
#include "cancan.h"

/*
 * mapping variables
 */
static char mappath[MAXMAPLEN]; /* circular path list */
static int mapstart = 0;	/* index to first map entry */
static int mapend = 0;		/* index one past last map entry */

#define MAPINDEX(i) (((i) + MAXMAPLEN) % MAXMAPLEN)
#define MAPENTRY(i) mappath[MAPINDEX(i)]

/*
 * return reverse direction
 */
char reverse_dir(dir)
char dir;
{
    static char dirs[] = "nsewud";
    char *p = strchr(dirs, dir);
    return p ? dirs[(p - dirs) ^ 1] : 0;
}

/*
 * retrace steps on map, optionally walk them back
 */
void retrace_steps(steps, walk_back)
int steps, walk_back;
{
    static char cmd[2];
    if (!steps && !walk_back)
      mapend = mapstart;
    else while(mapstart != mapend && steps--) {
	mapend = MAPINDEX(mapend - 1);
	if(walk_back) {
	    cmd[0] = reverse_dir(mappath[mapend]);
	    send_to_main_host(cmd);
	}
    }
}

/*
 * show automatic map (latest steps) in the form s2ews14n
 */
void show_automap()
{
    char lastdir;
    int count = 0;
    int i;

    if(mapstart == mapend)
        tty_puts("#map empty\n");
    else {
        tty_puts("#map: ");

	lastdir = mappath[mapstart];
	for(i = mapstart; i != mapend; i = MAPINDEX(i + 1)) {
	    if(mappath[i] != lastdir) {
		if(count > 1)
		    tty_printf("%d", count);
		tty_putc(lastdir);

		count = 1;
		lastdir = mappath[i];
	    } else
		count++;
	}

	if(count > 1)
	    tty_printf("%d", count);

	tty_printf("%c\n", lastdir);
    } 
}

/*
 * print map to string in the form seewsnnnnnnnnnnnnnn
 */
void print_automap(buf)
char *buf;
{
    int i;

    if(mapstart != mapend)
	for(i = mapstart; i != mapend; i = MAPINDEX(i + 1))
	    *buf++ = mappath[i];
    *buf = '\0';
}

/*
 * add direction to automap
 */
void add_dir_to_map(dir)
char dir;
{
#ifdef NOMAZEMAPPING
    if(mapend != mapstart && dir == reverse_dir(MAPENTRY(mapend - 1))) {
	mapend = MAPINDEX(mapend - 1); /* retrace one step */
    } else
#endif
    {
	MAPENTRY(mapend) = dir;
	mapend = MAPINDEX(mapend + 1);
	if(mapend == mapstart)
	    mapstart = MAPINDEX(mapstart + 1);
    }
}
