/* publics from term.c */

extern int metakey;
extern int wrapglitch;
extern char clreoln[];
extern char clreoscr[];
extern char begoln[];
extern char modebold[], modeuline[], modenorm[], backupmodenorm[], modeinv[];
extern char modestandon[], modestandoff[];

void set_terminal();
void reset_terminal();
void set_spec_keys();
void settermcap();
void default_keybindings();
void init_keybindings();
void tty_gotoxy();
void optmove();
void clearinpline();
void redraw_input();
void deletechars();
void insertchars();
void winchsig();

#ifdef WIN32

void tty_putc();
void tty_puts();
void tty_printf(char *format, ...);
#define tty_flush()

#else

#define tty_putc(c) putchar((int)(c))
#define tty_puts(s) fputs((s), stdout)
#define tty_printf  printf
#define tty_flush() fflush(stdout)

#endif

