typedef int operator;

#define TYPE_NUM 1
#define TYPE_TXT 2
#define TYPE_NUM_VAR 3
#define TYPE_TXT_VAR 4

typedef struct {
  int type;
  long num;      /* used for numeric types or as index for all variables */
  char *txt;     /* used as pointer for text types */
} object;

#define MAX_STACK 100

#define STACK_OV_ERROR    1
#define STACK_UND_ERROR   2
#define SYNTAX_ERROR      3
#define NO_OPERATOR_ERROR 4
#define NO_VALUE_ERROR    5
#define DIV_BY_ZERO_ERROR 6
#define OUT_RANGE_ERROR   7
#define MISSING_PAREN_ERROR  8
#define MISMATCH_PAREN_ERROR 9
#define NO_MEM_ERROR        10
#define NOT_DONE_ERROR      11
#define MAX_LOOP_ERROR      12
#define NO_NUM_VALUE_ERROR  13
#define NO_STRING_ERROR     14
#define DYN_STACK_OV_ERROR  15
#define DYN_STACK_UND_ERROR 16
#define NO_LABEL_ERROR      17
#define MISSING_SEPARATOR_ERROR 18
#define NESTED_HISTORY_ERROR 19
#define USER_BREAK 20
#define OUT_OF_VAR_SPACE_ERROR 21
#define UNDEFINED_VARIABLE_ERROR 22

typedef struct {
  object obj[MAX_STACK];
  int curr_obj;
  operator op[MAX_STACK];
  int curr_op;
} stack;

#define LEFT  1
#define RIGHT 2

#define BINARY     0
#define PRE_UNARY  LEFT
#define POST_UNARY RIGHT

typedef struct {
  char priority, assoc, syntax, *name;
} operator_list;

#define MAX_OPERATOR 100
#define MAX_PRIORITY 127

#define LOWEST_UNARY_CODE 49
/*
 *  it would be 47, but operators 47 '(' and 48 ')'
 *  are treated separately
 */

enum op_codes {
  null=0, comma, eq, or_or_eq, xor_xor_eq, and_and_eq, or_eq, xor_eq, and_eq,
  lshift_eq, rshift_eq, plus_eq, minus_eq, times_eq, div_eq, ampersand_eq,
  or_or, xor_xor, and_and, or, xor, and,
  less, less_eq, greater, greater_eq, eq_eq, not_eq,
  lshift, rshift, plus, minus, times, division, ampersand,

  colon_less, colon_greater, less_colon, greater_colon,
  point_less, point_greater, less_point, greater_point,
  colon, point, question, another_null,

  left_paren, right_paren, not, tilde,
  pre_plus_plus, post_plus_plus, pre_minus_minus, post_minus_minus,
  star, print, _random_, colon_question, point_question,
  pre_plus, pre_minus, a_circle, dollar, pre_null, post_null
};

void print_error();
int my_strstr();
int my_strrstr();

#define PRINT_NOTHING 0
#define PRINT_AS_TEXT 1
#define PRINT_AS_NUM  2

int xeval();

extern char *error_msg[];
extern operator_list op_list[];
extern int error;

